<?php
/**
 * Product table template (part of various emails)
 *
 * @author  YITH <plugins@yithemes.com>
 * @package YITH\Wishlist\Templates\Emails
 * @version 3.0.0
 */

/**
 * Template variables:
 *
 * @var $email_heading string Email heading string
 * @var $email         \WC_Email Email object
 * @var $email_content string Email content (HTML)
 * @var $items         YITH_WCWL_Wishlist_Item[]
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
} // Exit if accessed directly

$contexts = array(
	'yith_wcwl_on_sale_item'   => 'price-comparison',
	'yith_wcwl_promotion_mail' => 'price-comparison',
	'yith_wcwl_back_in_stock'  => 'show-stock',
);

$context = $contexts[ $email->id ] ?? 'price-comparison';

$text_align = is_rtl() ? 'right' : 'left';

?>

<table class="td" cellspacing="0" cellpadding="6" style="border:none; width: 100%; font-family: 'Helvetica Neue', Helvetica, Roboto, Arial, sans-serif; margin: 0 0 16px; border-collapse:separate; border-spacing:0 15px;">
	<tbody>
	<?php foreach ( $items as $item ) : ?>

		<?php
		/**
		 * Product for current item
		 *
		 * @var $product \WC_Product
		 */
		$product = $item->get_product();

		if ( ! $product ) {
			continue;
		}
		?>

		<?php
		/**
		 * APPLY_FILTERS: yith_wcwl_wishlist_item_class
		 *
		 * Filter the CSS class added to each product row inside the emails.
		 *
		 * @param string                  $class CSS class
		 * @param YITH_WCWL_Wishlist_Item $item  Wishlist item object
		 *
		 * @return string
		 */
		?>
		<tr class="<?php echo esc_attr( apply_filters( 'yith_wcwl_wishlist_item_class', 'wishlist_item', $item ) ); ?>" style="background:#f6f6f6;">
			<td class="td" style="text-align:<?php echo esc_attr( $text_align ); ?>; vertical-align: middle; font-family: 'Helvetica Neue', Helvetica, Roboto, Arial, sans-serif; word-wrap:break-word; border:none; padding:20px 10px 20px 20px; width:90px;">
				<?php echo wp_kses_post( $product->get_image( array( 90, 90 ) ) ); ?>
			</td>
			<td class="td" style="text-align:<?php echo esc_attr( $text_align ); ?>; vertical-align: middle; font-family: 'Helvetica Neue', Helvetica, Roboto, Arial, sans-serif; word-wrap:break-word; border:none; font-size:14px;">
				<div style="margin-bottom: 10px;">
					<?php printf( '<a href="%s" style="text-decoration:none;"><strong>%s</strong></a>', esc_url( $product->get_permalink() ), wp_kses_post( $product->get_name() ) ); ?>
				</div>
				<?php if ( 'price-comparison' === $context && $product->is_on_sale() ): ?>
					<div style="margin-bottom: 5px; font-size: 12px;">
						<?php printf( __( 'Original price: %s', 'yith-woocommerce-wishlist' ), '<del>' . wc_price( $product->get_regular_price() ) . '</del>' ); // translators: %s is the regular price. ?>
					</div>
					<div style="margin-bottom: 10px;">
						<strong>
							<?php printf( __( 'Current price: %s', 'yith-woocommerce-wishlist' ), wc_price( $product->get_sale_price() ) ); // translators: %s is the regular price. ?>
						</strong>
					</div>
				<?php else: ?>
					<div>
						<?php echo str_replace( 'ins', 'strong', $product->get_price_html() ); ?>
					</div>
				<?php endif; ?>
				<?php if ( 'show-stock' === $context && $product->is_in_stock() ): ?>
					<div style="color:#7b8a0c; margin-top:5px;">
						<?php _e( 'In stock', 'yith-woocommerce-wishlist' ); ?>
					</div>
				<?php endif; ?>
			</td>
			<td class="td" style="text-align:<?php echo esc_attr( $text_align ); ?>; vertical-align:middle; font-family: 'Helvetica Neue', Helvetica, Roboto, Arial, sans-serif; border:none;">
				<a style="display:block; background-color: #7f54b3; color: #fff; white-space: nowrap; padding: .618em 1em; border-radius: 3px; text-decoration: none;" href="<?php echo esc_url( add_query_arg( 'add-to-cart', $product->get_id(), $product->get_permalink() ) ); ?>">
					<?php echo wp_kses_post( $product->add_to_cart_text() ); ?>
				</a>
			</td>
		</tr>
	<?php endforeach; ?>
	</tbody>
</table>
