<?php // phpcs:ignore WordPress.Files.FileName.NotHyphenatedLowercase
/**
 * Wishlist Page premium settings
 *
 * @author  YITH <plugins@yithemes.com>
 * @package YITH\Wishlist\Options
 * @since   4.0.0
 */

defined( 'YITH_WCWL' ) || exit; // Exit if accessed directly.

$wishlist_page_premium_settings[] = array(
	'options' => array(
		'wishlist_manage_layout'      => array(
			'name'      => __( 'Layout for wishlist view', 'yith-woocommerce-wishlist' ),
			'desc'      => __( 'Select a style for your "Manage wishlists" page', 'yith-woocommerce-wishlist' ),
			'id'        => 'yith_wcwl_wishlist_manage_layout',
			'type'      => 'yith-field',
			'yith-type' => 'radio',
			'options'   => array(
				'traditional' => __( 'Traditional', 'yith-woocommerce-wishlist' ),
				'modern'      => __( 'Modern grid', 'yith-woocommerce-wishlist' ),
			),
			'default'   => 'traditional',
		),
		'show_manage_num_of_items'    => array(
			'name'          => __( 'Show wishlist info', 'yith-woocommerce-wishlist' ),
			'desc'          => __( 'Number of items in wishlist', 'yith-woocommerce-wishlist' ),
			'id'            => 'yith_wcwl_manage_num_of_items_show',
			'type'          => 'checkbox',
			'default'       => '',
			'checkboxgroup' => 'start',
		),
		'show_manage_creation_date'   => array(
			'name'          => __( 'Show wishlist info', 'yith-woocommerce-wishlist' ),
			'desc'          => __( 'Date of creation of the wishlist', 'yith-woocommerce-wishlist' ),
			'id'            => 'yith_wcwl_manage_creation_date_show',
			'type'          => 'checkbox',
			'default'       => '',
			'checkboxgroup' => 'manage_info',
		),
		'show_manage_download_pdf'    => array(
			'name'          => __( 'Show wishlist info', 'yith-woocommerce-wishlist' ),
			'desc'          => __( 'Download a PDF version of the wishlist', 'yith-woocommerce-wishlist' ),
			'id'            => 'yith_wcwl_manage_download_pdf_show',
			'type'          => 'checkbox',
			'default'       => '',
			'checkboxgroup' => 'manage_info',
		),
		'show_manage_rename_wishlist' => array(
			'name'          => __( 'Show wishlist info', 'yith-woocommerce-wishlist' ),
			'desc'          => __( 'Rename wishlist button', 'yith-woocommerce-wishlist' ),
			'id'            => 'yith_wcwl_manage_rename_wishlist_show',
			'type'          => 'checkbox',
			'default'       => 'no',
			'checkboxgroup' => 'manage_info',
		),
		'show_manage_delete_wishlist' => array(
			'name'          => __( 'Show wishlist info', 'yith-woocommerce-wishlist' ),
			'desc'          => __( 'Delete wishlist button', 'yith-woocommerce-wishlist' ),
			'id'            => 'yith_wcwl_manage_delete_wishlist_show',
			'type'          => 'checkbox',
			'default'       => 'yes',
			'checkboxgroup' => 'end',
		),
		'new_wishlist_as_popup'       => array(
			'name'      => __( '"Create wishlist" in popup', 'yith-woocommerce-wishlist' ),
			'desc'      => __( 'Create a new wishlist in the popup instead of using the endpoint', 'yith-woocommerce-wishlist' ),
			'id'        => 'yith_wcwl_create_wishlist_popup',
			'type'      => 'yith-field',
			'yith-type' => 'onoff',
			'default'   => 'no',
		),
	),
	'pivot'   => 'wishlist_page',
);

$wishlist_page_premium_settings[] = array(
	'options' => array(
		'wishlist_layout' => array(
			'name'      => __( 'Layout for product list', 'yith-woocommerce-wishlist' ),
			'desc'      => __( 'Select a style for displaying your wishlist page', 'yith-woocommerce-wishlist' ),
			'id'        => 'yith_wcwl_wishlist_layout',
			'type'      => 'yith-field',
			'yith-type' => 'radio',
			'default'   => 'traditional',
			'options'   => array(
				'traditional' => __( 'Traditional', 'yith-woocommerce-wishlist' ),
				'modern'      => __( 'Modern grid', 'yith-woocommerce-wishlist' ),
				'images'      => __( 'Only images with info at click', 'yith-woocommerce-wishlist' ),
			),
		),
	),
	'pivot'   => 'wishlist_section_start',
);

$wishlist_page_premium_settings[] = array(
	'options' => array(
		'show_price_changes' => array(
			'name'          => __( 'In wishlist table show', 'yith-woocommerce-wishlist' ),
			'desc'          => __( 'Price variation info (show the price difference compared to when the product was added to the list)', 'yith-woocommerce-wishlist' ),
			'id'            => 'yith_wcwl_price_changes_show',
			'type'          => 'checkbox',
			'default'       => '',
			'checkboxgroup' => 'wishlist_info',
		),
	),
	'pivot'   => 'show_unit_price',
);

$wishlist_page_premium_settings[] = array(
	'options' => array(
		'show_cb' => array(
			'name'          => __( 'In wishlist table show', 'yith-woocommerce-wishlist' ),
			'desc'          => __( 'Checkbox to select multiple items, add them to the cart or delete them with one click', 'yith-woocommerce-wishlist' ),
			'id'            => 'yith_wcwl_cb_show',
			'type'          => 'checkbox',
			'default'       => '',
			'checkboxgroup' => 'wishlist_info',
		),
	),
	'pivot'   => 'show_remove_button',
);

$wishlist_page_premium_settings[] = array(
	'options' => array(
		'show_move_to_another_wishlist' => array(
			'name'      => __( 'Show Move to another wishlist', 'yith-woocommerce-wishlist' ),
			'desc'      => __( 'Enable the option to move the product to another wishlist', 'yith-woocommerce-wishlist' ),
			'id'        => 'yith_wcwl_show_move_to_another_wishlist',
			'type'      => 'yith-field',
			'yith-type' => 'onoff',
			'default'   => '',
		),
		'move_to_another_wishlist_type' => array(
			'name'      => __( 'Move to another wishlist - style', 'yith-woocommerce-wishlist' ),
			'desc'      => __( 'Choose the look and feel of the "Move to another wishlist" option', 'yith-woocommerce-wishlist' ),
			'id'        => 'yith_wcwl_move_to_another_wishlist_type',
			'type'      => 'yith-field',
			'yith-type' => 'radio',
			'default'   => 'popup',
			'options'   => array(
				'select' => __( 'Select dropdown with all wishlists', 'yith-woocommerce-wishlist' ),
				'popup'  => __( 'Link to a popup', 'yith-woocommerce-wishlist' ),
			),
			'deps'      => array(
				'id'    => 'yith_wcwl_show_move_to_another_wishlist',
				'value' => 'yes',
			),
		),
	),
	'pivot'   => 'repeat_remove_button',
);

$wishlist_page_premium_settings[] = array(
	'options' => array(
		'enable_add_all_to_cart' => array(
			'name'      => __( 'Enable "Add all to cart"', 'yith-woocommerce-wishlist' ),
			'desc'      => __( 'Enable "Add all to cart" button to let customers add all the products in the wishlist to the cart', 'yith-woocommerce-wishlist' ),
			'id'        => 'yith_wcwl_enable_add_all_to_cart',
			'type'      => 'yith-field',
			'yith-type' => 'onoff',
			'default'   => 'no',
		),
		'enable_drag_n_drop'     => array(
			'name'      => __( 'Enable drag and drop option', 'yith-woocommerce-wishlist' ),
			'desc'      => __( 'Enable drag and drop option so users can arrange the order of products in the wishlist', 'yith-woocommerce-wishlist' ),
			'id'        => 'yith_wcwl_enable_drag_and_drop',
			'type'      => 'yith-field',
			'yith-type' => 'onoff',
			'default'   => 'no',
		),
		'enable_wishlist_links'  => array(
			'name'      => __( 'Show links to pages', 'yith-woocommerce-wishlist' ),
			'desc'      => __( 'Show the links to "Manage", "Create" and "Search" pages after the wishlist table', 'yith-woocommerce-wishlist' ),
			'id'        => 'yith_wcwl_enable_wishlist_links',
			'type'      => 'yith-field',
			'yith-type' => 'onoff',
			'default'   => 'yes',
		),
	),
	'pivot'   => 'remove_after_add_to_cart',
);

return $wishlist_page_premium_settings;
