<?php
/**
 * General settings premium options
 *
 * @package YITH\Wishlist\Options
 * @author  YITH
 * @since   4.0.0
 */

defined( 'YITH_WCWL' ) || exit; // Exit if accessed directly.

$general_options = array(
	array(
		'options' => array(
			'disable_wishlist_for_unauthenticated_users' => array(
				'name'      => __( 'Enable wishlist for', 'yith-woocommerce-wishlist' ),
				'desc'      => __( 'Choose whether to enable the wishlist feature for all users or only for logged-in users', 'yith-woocommerce-wishlist' ),
				'id'        => 'yith_wcwl_disable_wishlist_for_unauthenticated_users',
				'options'   => array(
					'no'  => __( 'All users', 'yith-woocommerce-wishlist' ),
					'yes' => __( 'Only authenticated users', 'yith-woocommerce-wishlist' ),
				),
				'default'   => 'no',
				'type'      => 'yith-field',
				'yith-type' => 'radio',
			),

			'enable_add_to_wishlist_notices' => array(
				'name'      => __( 'Enable Added/Removed notices', 'yith-woocommerce-wishlist' ),
				'desc'      => __( 'Enable popup notices when the product is added or removed from the wishlist', 'yith-woocommerce-wishlist' ),
				'id'        => 'yith_wcwl_notices_enable',
				'default'   => 'yes',
				'type'      => 'yith-field',
				'yith-type' => 'onoff',
			),

			'enable_add_to_wishlist_tooltip' => array(
				'name'      => __( 'Enable "Add to wishlist" tooltip', 'yith-woocommerce-wishlist' ),
				'desc'      => __( 'Choose whether to display a tooltip when hovering over Add to wishlist link', 'yith-woocommerce-wishlist' ),
				'id'        => 'yith_wcwl_tooltip_enable',
				'default'   => 'no',
				'type'      => 'yith-field',
				'yith-type' => 'onoff',
			),
		),
		'pivot'   => 'general_section_start',
	),
	array(
		'options' => array(
			'multi_wishlist_section_start' => array(
				'name' => __( 'Multi-wishlist settings', 'yith-woocommerce-wishlist' ),
				'type' => 'title',
				'desc' => '',
				'id'   => 'yith_wcwl_multi_wishlist_settings',
			),

			'enable_multi_wishlist' => array(
				'name'      => __( 'Enable multi-wishlist feature', 'yith-woocommerce-wishlist' ),
				'desc'      => __( 'Allow customers to create and manage multiple wishlists', 'yith-woocommerce-wishlist' ),
				'id'        => 'yith_wcwl_multi_wishlist_enable',
				'default'   => 'no',
				'type'      => 'yith-field',
				'yith-type' => 'onoff',
			),

			'enable_multi_wishlist_for_unauthenticated_users' => array(
				'name'      => __( 'Enable multiple wishlists for', 'yith-woocommerce-wishlist' ),
				'desc'      => __( 'Choose whether to enable the multi-wishlist feature for all users or just for logged-in users', 'yith-woocommerce-wishlist' ),
				'id'        => 'yith_wcwl_enable_multi_wishlist_for_unauthenticated_users',
				'options'   => array(
					'yes' => __( 'All users', 'yith-woocommerce-wishlist' ),
					'no'  => __( 'Only authenticated users', 'yith-woocommerce-wishlist' ),
				),
				'default'   => 'no',
				'type'      => 'yith-field',
				'yith-type' => 'radio',
			),

			'multi_wishlist_section_end' => array(
				'type' => 'sectionend',
				'id'   => 'yith_wcwl_multi_wishlist_settings',
			),
		),
		'pivot'   => 'general_section_end',
	),
);

if ( ! YITH_WCWL_Frontend::is_php_templates_mode() ) {
	unset( $general_options[ 0 ][ 'options' ][ 'enable_add_to_wishlist_notices' ] );
}

return $general_options;
