<?php // phpcs:ignore WordPress.Files.FileName.NotHyphenatedLowercase
/**
 * Add to Wishlist premiumsettings
 *
 * @var bool $multi_wishlist_enabled Whether the multi wishlist is enabled or not.
 *
 * @package YITH\Wishlist\Options
 * @author  YITH <plugins@yithemes.com>
 * @since   3.0.0
 */

defined( 'YITH_WCWL' ) || exit; // Exit if accessed directly.

$multi_wishlist_enabled          = 'yes' === get_option( 'yith_wcwl_multi_wishlist_enable', 'yes' );
$add_to_wishlist_premium_options = array();

$feedback_type_options = array(
	'name'            => __( 'When a product is added to wishlist', 'yith-woocommerce-wishlist' ),
	'desc'            => __( 'Choose how to show the feedback when an item is added to the wishlist.', 'yith-woocommerce-wishlist' ),
	'id'              => 'yith_wcwl_add_to_wishlist_feedback',
	'default'         => 'notice',
	'type'            => 'yith-field',
	'yith-type'       => 'radio',
	'extra_row_class' => 'yith-wcwl-react-only-option',
	'options'         => array(
		'notice' => __( 'Show a notice', 'yith-woocommerce-wishlist' ),
		'modal'  => __( 'Show a modal window', 'yith-woocommerce-wishlist' ),
	),
);

if ( $multi_wishlist_enabled ) {
	$add_to_wishlist_premium_options[] = array(
		'options' => array(
			'enable_add_to_wishlist_modal'            => array(
				'name'      => __( 'When clicking on Add to wishlist', 'yith-woocommerce-wishlist' ),
				'desc'      => __( 'Choose the default action for new products added to the wishlist.', 'yith-woocommerce-wishlist' ),
				'id'        => 'yith_wcwl_modal_enable',
				'default'   => 'yes',
				'type'      => 'yith-field',
				'yith-type' => 'radio',
				'options'   => array(
					'default' => __( 'Automatically add to the default list', 'yith-woocommerce-wishlist' ),
					'yes'     => __( 'Show a modal window to allow users to choose a wishlist', 'yith-woocommerce-wishlist' ),
					'no'      => __( 'Show a dropdown to allow users to choose a wishlist', 'yith-woocommerce-wishlist' ),
				),
			),
			'add_to_wishlist_feedback'                => $feedback_type_options,
			'add_to_wishlist_modal_closing_behaviour' => array(
				'name'      => __( 'Modal closure options', 'yith-woocommerce-wishlist' ),
				'desc'      => __( 'Choose whether to close the feedback modal automatically or keep it open.', 'yith-woocommerce-wishlist' ),
				'id'        => 'yith_wcwl_modal_close_behaviour',
				'default'   => 'close',
				'type'      => 'yith-field',
				'yith-type' => 'radio',
				'deps'      => 'react-components' === get_option('yith_wcwl_rendering_method', false) ? array(
					'id'    => 'yith_wcwl_add_to_wishlist_feedback',
					'value' => 'modal',
					'type'  => 'hide',
				) : array(),
				'options'   => array(
					'close' => __( 'Automatically close the modal', 'yith-woocommerce-wishlist' ),
					'open'  => __( 'Leave the modal open', 'yith-woocommerce-wishlist' ),
				),
			),
		),
		'pivot'   => 'general_section_start',
	);
} else {
	$add_to_wishlist_premium_options[] = array(
		'options' => array(
			'add_to_wishlist_feedback' => $feedback_type_options,
		),
		'pivot'   => 'general_section_start',
	);

}

$add_to_wishlist_premium_options[] = array(
	'options' => array(
		'position_over_image_in_loop' => array(
			'name'            => __( 'Position on product image', 'yith-woocommerce-wishlist' ),
			'desc'            => __( 'Choose the position of the "Add to wishlist" icon on product images', 'yith-woocommerce-wishlist' ),
			'id'              => 'yith_wcwl_position_over_image_in_loop',
			'extra_row_class' => 'yith-wcwl-react-only-option',
			'default'         => 'top-left',
			'type'            => 'yith-field',
			'class'           => 'wc-enhanced-select',
			'yith-type'       => 'select',
			'options'         => array(
				'top-left'     => __( 'Top left', 'yith-woocommerce-wishlist' ),
				'top-right'    => __( 'Top Right', 'yith-woocommerce-wishlist' ),
				'bottom-left'  => __( 'Bottom Left', 'yith-woocommerce-wishlist' ),
				'bottom-right' => __( 'Bottom Right', 'yith-woocommerce-wishlist' ),
			),
			'deps'            => array(
				'id'    => 'yith_wcwl_loop_position',
				'value' => 'before_image',
			),
		),
		'button_over_image_style'     => array(
			'name'            => __( 'Icon style', 'yith-woocommerce-wishlist' ),
			'desc'            => __( 'Choose whether to always show the wishlist icon or only when hovering over the product', 'yith-woocommerce-wishlist' ),
			'id'              => 'yith_wcwl_button_over_image_style',
			'extra_row_class' => 'yith-wcwl-react-only-option',

			'default'   => 'fixed',
			'type'      => 'yith-field',
			'yith-type' => 'radio',
			'options'   => array(
				'fixed' => __( 'Fixed', 'yith-woocommerce-wishlist' ),
				'hover' => __( 'On hover', 'yith-woocommerce-wishlist' ),
			),
			'deps'      => array(
				'id'    => 'yith_wcwl_loop_position',
				'value' => 'before_image',
			),
		),
		'show_count_in_loop'          => array(
			'name'      => __( 'Show a count of users with a specific product in wishlist', 'yith-woocommerce-wishlist' ),
			'desc'      => __( 'Display a counter in the loop to show your customers how many times the product has been added to a wishlist.', 'yith-woocommerce-wishlist' ),
			'id'        => 'yith_wcwl_show_counter_in_loop',
			'default'   => 'no',
			'type'      => 'yith-field',
			'yith-type' => 'onoff',
			'deps'      => array(
				'id'    => 'yith_wcwl_show_on_loop',
				'value' => 'yes',
			),
		),
	),
	'pivot'   => 'loop_position',
);

// add options for product page.
$add_to_wishlist_premium_options[] = array(
	'options' => array(
		'show_times_in_wishlist' => array(
			'name'      => __( 'Show a count of users with a specific product in wishlist', 'yith-woocommerce-wishlist' ),
			'desc'      => __( 'Display a counter on the product page to show your customers how many times the product has been added to a wishlist.', 'yith-woocommerce-wishlist' ),
			'id'        => 'yith_wcwl_show_counter',
			'default'   => 'no',
			'type'      => 'yith-field',
			'yith-type' => 'onoff',
		),
	),
	'pivot'   => 'add_to_wishlist_position',
);

return $add_to_wishlist_premium_options;
