<?php
/**
 * Style subtab of customization settings
 *
 * @package YITH\Wishlist\Options
 * @author  YITH <plugins@yithemes.com>
 * @since   4.0.0
 */

defined( 'YITH_WCWL' ) || exit; // Exit if accessed directly

$customization_style_premium_options = array();
$modal_colors_defaults               = yith_wcwl_get_modal_colors_defaults();

if ( 'yes' === get_option( 'yith_wcwl_tooltip_enable' ) ) {
	$customization_style_premium_options[] = array(
		'options' => array(
			'add_to_wishlist_tooltip_style' => array(
				'name'         => __( 'Add to wishlist tooltip style', 'yith-woocommerce-wishlist' ),
				'desc'         => __( 'Choose colors for Add to wishlist tooltip', 'yith-woocommerce-wishlist' ),
				'id'           => 'yith_wcwl_tooltip_color',
				'type'         => 'yith-field',
				'yith-type'    => 'multi-colorpicker',
				'colorpickers' => array(
					array(
						'name'    => __( 'Background', 'yith-woocommerce-wishlist' ),
						'id'      => 'background',
						'default' => '#333333e6',
					),
					array(
						'name'    => __( 'Text', 'yith-woocommerce-wishlist' ),
						'id'      => 'text',
						'default' => '#fff',
					),
				),
				'deps'         => array(
					'id'    => 'yith_wcwl_tooltip_enable',
					'value' => 'yes',
				),
			),
		),
		'pivot'   => 'add_to_wishlist_start',
	);
}

if ( ! YITH_WCWL_Rendering_Method_Admin_Handler::is_php_templates_mode() ) {
	$customization_style_premium_options[] = array(
		'options' => array(
			'modals_start'      => array(
				'name' => __( 'Modals', 'yith-woocommerce-wishlist' ),
				'type' => 'title',
				'desc' => '',
			),
			'modal_icon_type'   => array(
				'name'      => __( 'Modal icon type', 'yith-woocommerce-wishlist' ),
				'desc'      => __( 'Select the icon type you want to use in the "Add to wishlist" modal', 'yith-woocommerce-wishlist' ),
				'id'        => 'yith_wcwl_modal_icon_type',
				'default'   => 'default',
				'type'      => 'yith-field',
				'yith-type' => 'radio',
				'options'   => array(
					'default'       => __( 'Use default icons', 'yith-woocommerce-wishlist' ),
					'same-to-add'   => __( 'Same used for the "Add to wishlist" button', 'yith-woocommerce-wishlist' ),
					'same-to-added' => __( 'Same used for the "Added to wishlist" button', 'yith-woocommerce-wishlist' ),
					'default-set'   => __( 'Use an icon from the default set', 'yith-woocommerce-wishlist' ),
					'custom'        => __( 'Upload a custom icon', 'yith-woocommerce-wishlist' ),
				),
			),
			'modal_icon'        => array(
				'name'      => __( 'Modal icon', 'yith-woocommerce-wishlist' ),
				'desc'      => __( 'Select an icon to show in the "Add to wishlist" modal', 'yith-woocommerce-wishlist' ),
				'id'        => 'yith_wcwl_modal_icon',
				'type'      => 'yith-field',
				'yith-type' => 'select',
				'class'     => 'icon-select',
				'options'   => yith_wcwl_get_plugin_icons_options( array( 'add-to-wishlist', 'added-to-wishlist' ) ),
				'deps'      => array(
					'id'    => 'yith_wcwl_modal_icon_type',
					'value' => 'default-set',
				),
			),
			'modal_custom_icon' => array(
				'name'      => __( 'Modal custom icon', 'yith-woocommerce-wishlist' ),
				'desc'      => __( "Upload an icon you'd like to use in the plugin's modals (suggested 32px x 32px)", 'yith-woocommerce-wishlist' ),
				'id'        => 'yith_wcwl_modal_custom_icon',
				'default'   => '',
				'type'      => 'yith-field',
				'yith-type' => 'media',
				'deps'      => array(
					'id'    => 'yith_wcwl_modal_icon_type',
					'value' => 'custom',
				),
			),
			'modal_colors'      => array(
				'name'         => __( 'Modal style', 'yith-woocommerce-wishlist' ),
				'desc'         => __( 'Choose the colors for the elements in the modal', 'yith-woocommerce-wishlist' ),
				'id'           => 'yith_wcwl_modal_colors',
				'type'         => 'yith-field',
				'yith-type'    => 'multi-colorpicker',
				'colorpickers' => array(
					array(
						'name'    => __( 'Overlay', 'yith-woocommerce-wishlist' ),
						'id'      => 'overlay',
						'default' => $modal_colors_defaults[ 'overlay' ],
					),
					array(
						'name'    => __( 'Icon', 'yith-woocommerce-wishlist' ),
						'id'      => 'icon',
						'default' => $modal_colors_defaults[ 'icon' ],
					),
					array(
						array(
							'name'    => __( 'Primary button', 'yith-woocommerce-wishlist' ),
							'id'      => 'primary_button',
							'default' => $modal_colors_defaults[ 'primary_button' ],
						),
						array(
							'name'    => __( 'Primary button hover', 'yith-woocommerce-wishlist' ),
							'id'      => 'primary_button_hover',
							'default' => $modal_colors_defaults[ 'primary_button_hover' ],
						),
					),
					array(
						array(
							'id'      => 'primary_button_text',
							'name'    => __( 'Primary button text', 'yith-woocommerce-wishlist' ),
							'default' => $modal_colors_defaults[ 'primary_button_text' ],
						),
						array(
							'id'      => 'primary_button_text_hover',
							'name'    => __( 'Primary button text hover', 'yith-woocommerce-wishlist' ),
							'default' => $modal_colors_defaults[ 'primary_button_text_hover' ],
						),
					),
					array(
						array(
							'name'    => __( 'Secondary button', 'yith-woocommerce-wishlist' ),
							'id'      => 'secondary_button',
							'default' => $modal_colors_defaults[ 'secondary_button' ],
						),
						array(
							'name'    => __( 'Secondary button hover', 'yith-woocommerce-wishlist' ),
							'id'      => 'secondary_button_hover',
							'default' => $modal_colors_defaults[ 'secondary_button_hover' ],
						),
					),
					array(
						array(
							'id'      => 'secondary_button_text',
							'name'    => __( 'Secondary button text', 'yith-woocommerce-wishlist' ),
							'default' => $modal_colors_defaults[ 'secondary_button_text' ],
						),
						array(
							'id'      => 'secondary_button_text_hover',
							'name'    => __( 'Secondary button text hover', 'yith-woocommerce-wishlist' ),
							'default' => $modal_colors_defaults[ 'secondary_button_text_hover' ],
						),
					),
				),
			),
			'modals_end'        => array(
				'type' => 'sectionend',
			),
		),
	);
}

$customization_style_premium_options[] = array(
	'options' => array(
		'ask_an_estimate_start'       => array(
			'name' => __( 'Ask for an estimate', 'yith-woocommerce-wishlist' ),
			'type' => 'title',
		),
		'ask_an_estimate_use_buttons' => array(
			'name'      => __( 'Style of "Ask for an estimate"', 'yith-woocommerce-wishlist' ),
			'desc'      => __( 'Choose if you want to show a textual "Ask for an Estimate" link or a button', 'yith-woocommerce-wishlist' ),
			'id'        => 'yith_wcwl_ask_an_estimate_style',
			'options'   => array(
				'link'           => __( 'Textual (anchor)', 'yith-woocommerce-wishlist' ),
				'button_default' => __( 'Button with theme style', 'yith-woocommerce-wishlist' ),
				'button_custom'  => __( 'Button with custom style', 'yith-woocommerce-wishlist' ),
			),
			'default'   => 'button_default',
			'type'      => 'yith-field',
			'yith-type' => 'radio',
		),

		'ask_an_estimate_colors' => array(
			'name'         => __( '"Ask for an Estimate" button style', 'yith-woocommerce-wishlist' ),
			'id'           => 'yith_wcwl_color_ask_an_estimate',
			'type'         => 'yith-field',
			'yith-type'    => 'multi-colorpicker',
			'colorpickers' => array(
				array(
					'desc' => '<br>' . __( 'Choose colors for the "Ask for an estimate" button', 'yith-woocommerce-wishlist' ),
					array(
						'name'    => __( 'Background', 'yith-woocommerce-wishlist' ),
						'id'      => 'background',
						'default' => '#333333',
					),
					array(
						'name'    => __( 'Text', 'yith-woocommerce-wishlist' ),
						'id'      => 'text',
						'default' => '#FFFFFF',
					),
					array(
						'name'    => __( 'Border', 'yith-woocommerce-wishlist' ),
						'id'      => 'border',
						'default' => '#333333',
					),
				),
				array(
					'desc' => '<br>' . __( 'Choose colors for the "Ask for an estimate" button on hover state', 'yith-woocommerce-wishlist' ),
					array(
						'name'    => __( 'Background Hover', 'yith-woocommerce-wishlist' ),
						'id'      => 'background_hover',
						'default' => '#4F4F4F',
					),
					array(
						'name'    => __( 'Text Hover', 'yith-woocommerce-wishlist' ),
						'id'      => 'text_hover',
						'default' => '#FFFFFF',
					),
					array(
						'name'    => __( 'Border Hover', 'yith-woocommerce-wishlist' ),
						'id'      => 'border_hover',
						'default' => '#4F4F4F',
					),
				),
			),
			'deps'         => array(
				'id'    => 'yith_wcwl_ask_an_estimate_style',
				'value' => 'button_custom',
			),
		),

		'ask_an_estimate_rounded_buttons_radius' => array(
			'name'      => __( 'Border radius', 'yith-woocommerce-wishlist' ),
			'desc'      => __( 'Choose radius for the "Ask for an Estimate" button', 'yith-woocommerce-wishlist' ),
			'id'        => 'yith_wcwl_ask_an_estimate_rounded_corners_radius',
			'default'   => 16,
			'type'      => 'yith-field',
			'yith-type' => 'slider',
			'min'       => 1,
			'max'       => 100,
			'deps'      => array(
				'id'    => 'yith_wcwl_ask_an_estimate_style',
				'value' => 'button_custom',
			),
		),

		'ask_an_estimate_icon_type' => array(
			'name'      => __( '"Ask for an estimate" icon type', 'yith-woocommerce-wishlist' ),
			'desc'      => __( 'Choose whether to use one of the default icons or a custom one', 'yith-woocommerce-wishlist' ),
			'id'        => 'yith_wcwl_ask_an_estimate_icon_type',
			'default'   => 'default',
			'type'      => 'yith-field',
			'yith-type' => 'radio',
			'options'   => array(
				'none'    => __( 'Show the button without the icon', 'yith-woocommerce-wishlist' ),
				'default' => __( 'Use default icon', 'yith-woocommerce-wishlist' ),
				'custom'  => __( 'Upload a custom icon', 'yith-woocommerce-wishlist' ),
			),
			'deps'      => array(
				'id'    => 'yith_wcwl_ask_an_estimate_style',
				'value' => 'button_custom',
			),
		),

		'ask_an_estimate_icon' => array(
			'name'      => __( '"Ask for an estimate" button icon', 'yith-woocommerce-wishlist' ),
			'desc'      => __( 'Select an icon for the "Ask for an Estimate" button', 'yith-woocommerce-wishlist' ),
			'id'        => 'yith_wcwl_ask_an_estimate_icon',
			/**
			 * APPLY_FILTERS: yith_wcwl_ask_an_estimate_std_icon
			 *
			 * Filter the default 'Ask for an estimate' icon.
			 *
			 * @param string $icon Default icon
			 *
			 * @return string
			 */
			'default'   => apply_filters( 'yith_wcwl_ask_an_estimate_std_icon', '' ),
			'type'      => 'yith-field',
			'yith-type' => 'select',
			'class'     => 'icon-select',
			'options'   => yith_wcwl_get_plugin_icons_options( 'ask-an-estimate' ),
			'deps'      => array(
				'id'    => 'yith_wcwl_ask_an_estimate_icon_type',
				'value' => 'default',
			),
		),

		'ask_an_estimate_custom_icon' => array(
			'name'      => __( '"Ask for an estimate" custom icon', 'yith-woocommerce-wishlist' ),
			'desc'      => __( 'Upload an icon you\'d like to use for "Ask for an estimate" button (suggested 32px x 32px)', 'yith-woocommerce-wishlist' ),
			'id'        => 'yith_wcwl_ask_an_estimate_custom_icon',
			'default'   => '',
			'type'      => 'yith-field',
			'yith-type' => 'media',
			'deps'      => array(
				'id'    => 'yith_wcwl_ask_an_estimate_icon_type',
				'value' => 'custom',
			),
		),
		'ask_an_estimate_end'         => array(
			'type' => 'sectionend',
		),
	),
);

return $customization_style_premium_options;
