<?php
/**
 * Premium options for Style sub-tab of customization settings
 *
 * @package YITH\Wishlist\Options
 * @author  YITH <plugins@yithemes.com>
 * @since   4.0.0
 */

defined( 'YITH_WCWL' ) || exit; // Exit if accessed directly

$multi_wishlist_enabled                    = 'yes' === get_option( 'yith_wcwl_multi_wishlist_enable', 'no' );
$multi_wishlist_enabled_for_unauth_users   = 'yes' === get_option( 'yith_wcwl_enable_multi_wishlist_for_unauthenticated_users', 'yes' );
$ask_an_estimate_enabled                   = wc_string_to_bool( get_option( 'yith_wcwl_show_estimate_button', 'yes' ) );
$ask_an_estimate__additional_notes_enabled = wc_string_to_bool( get_option( 'yith_wcwl_show_additional_info_textarea', 'no' ) );

return array(
	array(
		'options' => array(
			'add_to_wishlist_popup_text' => array(
				'name'    => __( '"Add to wishlist" popup button text', 'yith-woocommerce-wishlist' ),
				'id'      => 'yith_wcwl_add_to_wishlist_popup_text',
				'desc'    => __( 'Text of the "Add to wishlist" button in the popup', 'yith-woocommerce-wishlist' ),
				'default' => __( 'Add to wishlist', 'yith-woocommerce-wishlist' ),
				'type'    => 'text',
			),
			'add_to_wishlist_move_text'  => array(
				'name'    => __( '"Move to another wishlist" text', 'yith-woocommerce-wishlist' ),
				'id'      => 'yith_wcwl_add_to_wishlist_move_text',
				'desc'    => __( 'Enter the text for the "Move to another wishlist" tooltip', 'yith-woocommerce-wishlist' ),
				'default' => __( 'Move to another wishlist', 'yith-woocommerce-wishlist' ),
				'type'    => 'text',
			),
		),
		'pivot'   => 'already_in_wishlist_text',
	),
	array(
		'options' => array(
			'create_wishlist_page_title' => array(
				'name'    => __( '"Create wishlist" page name', 'yith-woocommerce-wishlist' ),
				'id'      => 'yith_wcwl_wishlist_create_title',
				'desc'    => __( 'Enter the title for the "Create wishlist" page', 'yith-woocommerce-wishlist' ),
				'default' => __( 'Create a new wishlist', 'yith-woocommerce-wishlist' ),
				'type'    => 'text',
			),
			'manage_wishlist_page_title' => array(
				'name'    => __( '"Manage wishlist" page name', 'yith-woocommerce-wishlist' ),
				'id'      => 'yith_wcwl_wishlist_manage_title',
				'desc'    => __( 'Enter the title for "Manage wishlists" page', 'yith-woocommerce-wishlist' ),
				'default' => __( 'Your wishlists', 'yith-woocommerce-wishlist' ),
				'type'    => 'text',
			),
			'search_wishlist_page_title' => array(
				'name'    => __( '"Search wishlist" page name', 'yith-woocommerce-wishlist' ),
				'id'      => 'yith_wcwl_wishlist_search_title',
				'desc'    => __( 'Enter the title for "Search wishlists" page', 'yith-woocommerce-wishlist' ),
				'default' => __( 'Search a wishlist', 'yith-woocommerce-wishlist' ),
				'type'    => 'text',
			),
		),
		'pivot'   => 'default_wishlist_title',
	),

	'multi_wishlist_section' => $multi_wishlist_enabled && ! $multi_wishlist_enabled_for_unauth_users ? array(
		'options' => array(
			'multi_wishlist_start' => array(
				'name' => __( 'Multi-wishlist', 'yith-woocommerce-wishlist' ),
				'type' => 'title',
			),

			'show_login_notice' => array(
				'name'      => __( 'Login message for non-authenticated users', 'yith-woocommerce-wishlist' ),
				'id'        => 'yith_wcwl_show_login_notice',
				'desc'      => __( 'Enter the message to ask unauthenticated users to login so they will be able to use the multi-wishlist feature.<br/>Use the placeholder %login_anchor% (set up the text in the following option) to add an anchor and redirect users to the Login page.', 'yith-woocommerce-wishlist' ),
				'default'   => __( 'Please %login_anchor% to use all the wishlist features', 'yith-woocommerce-wishlist' ),
				'type'      => 'yith-field',
				'yith-type' => 'text',
				'deps'      => array(
					'id'    => 'yith_wcwl_enable_multi_wishlist_for_unauthenticated_users',
					'value' => 'no',
				),
			),

			'login_anchor_text' => array(
				'name'      => __( 'Login anchor text', 'yith-woocommerce-wishlist' ),
				'id'        => 'yith_wcwl_login_anchor_text',
				'desc'      => __( 'Set up here the text of the Login link that replace %login_anchor%', 'yith-woocommerce-wishlist' ),
				'default'   => __( 'login', 'yith-woocommerce-wishlist' ),
				'type'      => 'yith-field',
				'yith-type' => 'text',
				'deps'      => array(
					'id'    => 'yith_wcwl_enable_multi_wishlist_for_unauthenticated_users',
					'value' => 'no',
				),
			),

			'multi_wishlist_end' => array(
				'type' => 'sectionend',
			),
		),
	) : array(),

	'ask_an_estimate_section' => $ask_an_estimate_enabled ? array(
		'options' => array(
			'ask_an_estimate_start' => array(
				'type' => 'title',
				'name' => __( 'Ask for an estimate', 'yith-woocommerce-wishlist' ),
			),
			'ask_an_estimate_label' => array(
				'name'      => __( '"Ask for an estimate" button label', 'yith-woocommerce-wishlist' ),
				'id'        => 'yith_wcwl_ask_an_estimate_label',
				'desc'      => __( 'This option lets you customize the label of "Ask for an Estimate" button', 'yith-woocommerce-wishlist' ),
				'default'   => __( 'Ask for an estimate', 'yith-woocommerce-wishlist' ),
				'type'      => 'yith-field',
				'yith-type' => 'text',
				'deps'      => array(
					'id'    => 'yith_wcwl_show_estimate_button',
					'value' => 'yes',
				),
			),

			'ask_an_estimate_additional_notes_label' => $ask_an_estimate__additional_notes_enabled ? array(
				'name'      => __( '"Additional notes" textarea label', 'yith-woocommerce-wishlist' ),
				'id'        => 'yith_wcwl_additional_info_textarea_label',
				'desc'      => __( 'This option lets you customize the label for the "Additional notes" text area', 'yith-woocommerce-wishlist' ),
				'default'   => __( 'Additional notes', 'yith-woocommerce-wishlist' ),
				'type'      => 'yith-field',
				'yith-type' => 'textarea',
			) : array(),
			'ask_an_estimate_end'                    => array(
				'type' => 'sectionend',
			),
		),
	) : array(),
);
