<?php
/**
 * Settings options
 *
 * @author YITH <plugins@yithemes.com>
 * @package YITH\Wishlist\Options
 * @version 3.0.0
 */

defined( 'YITH_WCWL' ) || exit; // Exit if accessed directly.

$sub_tabs = array(
	'dashboard-lists'   => array(
		'title'              => _x( 'Wishlists', 'Tab title in plugin settings panel', 'yith-woocommerce-wishlist' ),
		'yith-wcwl-priority' => 20,
		'description'        => _x( 'See all the wishlists created in your site.', 'Tab description in plugin settings panel', 'yith-woocommerce-wishlist' ),
	),
	'dashboard-popular' => array(
		'title'              => _x( 'Popular', 'Tab title in plugin settings panel', 'yith-woocommerce-wishlist' ),
		'yith-wcwl-priority' => 20,
		'description'        => _x( 'Check the most popular products in your site.', 'Tab description in plugin settings panel', 'yith-woocommerce-wishlist' ),
	),
);

$options = array(
	'dashboard' => array(
		'dashboard-tabs' => array(
			'type'     => 'multi_tab',
			'nav-layout' => 'horizontal',
			'sub-tabs' => $sub_tabs,
		),
	),
);

return apply_filters( 'yith_wcwl_panel_dashboard_options', $options );
