<?php
/**
 * Init extended admin features of the plugin
 *
 * @package YITH\Wishlist\Classes
 * @author  YITH <plugins@yithemes.com>
 * @version 3.0.0
 */

if ( ! defined( 'YITH_WCWL' ) ) {
	exit;
} // Exit if accessed directly

if ( ! class_exists( 'YITH_WCWL_Admin_Extended' ) ) {
	/**
	 * WooCommerce Wishlist admin Premium
	 *
	 * @since 1.0.0
	 */
	class YITH_WCWL_Admin_Extended extends YITH_WCWL_Admin {
		/**
		 * Various links
		 *
		 * @since  1.0.0
		 * @var string
		 * @access public
		 */
		public $showcase_images = array();

		/**
		 * Constructor of the class
		 *
		 * @since 2.0.0
		 */
		public function __construct() {
			parent::__construct();

			add_action( 'wp_ajax_yith_wcwl_save_email_settings', array( $this, 'save_email_settings' ) );
			add_action( 'wp_ajax_nopriv_yith_wcwl_save_email_settings', array( $this, 'save_email_settings' ) );

			add_action( 'wp_ajax_yith_wcwl_save_mail_status', array( $this, 'save_mail_status' ) );
			add_action( 'wp_ajax_nopriv_yith_wcwl_save_mail_status', array( $this, 'save_mail_status' ) );
		}

		/* === INITIALIZATION SECTION === */

		/**
		 * Initiator method. Initiate properties.
		 *
		 * @return void
		 * @access private
		 * @since  1.0.0
		 */
		public function init() { // phpcs:ignore Generic.CodeAnalysis.UselessOverridingMethod.Found
			parent::init();
		}

		/**
		 * Add new options to wishlist settings tab
		 *
		 * @param array $options Array of available options.
		 * @return array Filtered array of options
		 *
		 * @depreacted since 4.0
		 * @use YITH_WCWL_Admin_Panel_Extended::add_options_in_wishlist_page_settings
		 */
		public function add_wishlist_options( $options ) {
			wc_deprecated_function( 'YITH_WCWL_Admin_Extended::add_wishlist_options()', '4.0.0', 'YITH_WCWL_Admin_Panel_Extended::add_options_in_wishlist_page_settings' );

			return $options;
		}

		/**
		 * Save email settings in ajax.
		 *
		 * @return void
		 */
		public function save_email_settings() {
			// phpcs:disable WordPress.Security.NonceVerification.Missing
			if ( isset( $_POST[ 'params' ] ) ) {
				parse_str( $_POST[ 'params' ], $params ); // phpcs:ignore WordPress.Security.ValidatedSanitizedInput.MissingUnslash, WordPress.Security.ValidatedSanitizedInput.InputNotSanitized
				unset( $_POST[ 'params' ] );

				foreach ( $params as $key => $value ) {
					$_POST[ $key ] = $value;
				}

				global $current_section;

				$email_key       = isset( $_POST[ 'email_key' ] ) ? strtolower( sanitize_text_field( wp_unslash( $_POST[ 'email_key' ] ) ) ) : '';
				$current_section = $email_key;

				$mailer = WC()->mailer();
				$class  = $mailer->emails[ $email_key ];
				$class->process_admin_options();

				$current_section = null;

				wp_send_json_success( array( 'msg' => 'Email updated' ) );
				die();
			}
			// phpcs:enable WordPress.Security.NonceVerification.Missing
		}

		/**
		 * Save email status in ajax.
		 *
		 * @return void
		 */
		public function save_mail_status() {
			// phpcs:disable WordPress.Security.NonceVerification.Missing
			if ( isset( $_POST[ 'email_key' ], $_POST[ 'enabled' ] ) ) {
				$email_key      = sanitize_text_field( wp_unslash( $_POST[ 'email_key' ] ) );
				$email_settings = get_option( 'woocommerce_' . $email_key . '_settings', array() );
				if ( is_array( $email_settings )) {
					$email_settings[ 'enabled' ] = sanitize_text_field( wp_unslash( $_POST[ 'enabled' ] ) );
					update_option( 'woocommerce_' . $email_key . '_settings', $email_settings );
				}
			}
			die();
			// phpcs:enable WordPress.Security.NonceVerification.Missing
		}

		/* === PANEL HANDLING === */

		/**
		 * Adds params to use in admin template files
		 *
		 * @return void
		 * @since 2.0.0
		 */
		public function print_popular_table() {
			if ( isset( $_GET[ 'action' ] ) && 'send_promotional_email' === $_GET[ 'action' ] && isset( $_GET[ '_wpnonce' ] ) && wp_verify_nonce( sanitize_text_field( wp_unslash( $_GET[ '_wpnonce' ] ) ), 'send_promotional_email' ) ) {
				$emails          = WC_Emails::instance()->get_emails();
				$promotion_email = $emails[ 'YITH_WCWL_Promotion_Email' ];

				$additional_info[ 'current_tab' ] = 'dashboard-popular';
				$additional_info[ 'product_id' ]  = isset( $_REQUEST[ 'product_id' ] ) ? intval( $_REQUEST[ 'product_id' ] ) : false;

				$additional_info[ 'promotional_email_html_content' ] = $promotion_email->get_option( 'content_html' );
				$additional_info[ 'promotional_email_text_content' ] = $promotion_email->get_option( 'content_text' );

				$additional_info[ 'coupons' ] = get_posts(
					array(
						'post_type'      => 'shop_coupon',
						'posts_per_page' => -1,
						'post_status'    => 'publish',
					)
				);

				yith_wcwl_get_template( 'admin/wishlist-panel-send-promotional-email.php', $additional_info );
			}
		}

		/**
		 * Build single email settings page
		 *
		 * @param string $email_key The email key.
		 *
		 * @return string
		 * @author Francesco Licandro
		 * @since  1.5.0
		 */
		public function build_single_email_settings_url( $email_key ) {
			return admin_url( 'admin.php?page=yith_wcwl_panel&tab=email&section=' . strtolower( $email_key ) );
		}
	}
}
