/* globals yithWcwlAddToWishlist  */

import { useButtonData } from '../../../../../utils';
import classNames from 'classnames';
import { __, _x } from '@wordpress/i18n';

export const useCreateAddToWishlistModalData = () => {
	const {
		modalWishlistName,
		setModalWishlistName,
		setModalWishlistNameError,
		modalWishlistPrivacy,
		setModalWishlistPrivacy,
		isCreatingWishlist,
		handleCreateAndAddToWishlist: createAndAddToWishlist,
		isLoading,
		setIsMoveModalOpened,
		setFeedbackAnimation,
	} = useButtonData();

	const buttonClasses = classNames(
		yithWcwlAddToWishlist.buttonClasses,
		'yith-wcwl-add-to-wishlist-modal__create-button',
		'yith-wcwl-modal__primary-button',
		{
			'yith-wcwl-modal__primary-button--loading': isCreatingWishlist || isLoading,
		}
	)

	const handleWishlistNameInputChange = ( e, wishlistName ) => {
		setModalWishlistName( wishlistName );
		setModalWishlistNameError( ! wishlistName );
	};
	const handleCreateAndAddToWishlist = () => {
		setModalWishlistNameError( ! modalWishlistName );

		if ( modalWishlistName ) {
			createAndAddToWishlist(
				{ wishlist_name: modalWishlistName, wishlist_visibility: modalWishlistPrivacy },
				() => {
					setIsMoveModalOpened( false )
					setFeedbackAnimation( false );
				} );
		}
	}
	const handlePrivacyChange = ( e, value ) => {
		setModalWishlistPrivacy( Number( value ) );
	}

	const getButtonLabel = () => {
		if ( isCreatingWishlist ) {
			return yithWcwlAddToWishlist.i18n.modals.add_to_wishlist.creating_wishlist_button;
		}

		return isLoading ? yithWcwlAddToWishlist.i18n.modals.add_to_wishlist.adding_wishlist_button : yithWcwlAddToWishlist.i18n.modals.add_to_wishlist.create_wishlist_button;
	};

	return {
		buttonClasses,
		buttonLabel: getButtonLabel(),

		handlePrivacyChange,
		handleCreateAndAddToWishlist,
		handleWishlistNameInputChange,
	}
}